/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.obj;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.obj.LineReader;
import net.minecraftforge.client.model.obj.MaterialLibrary;
import net.minecraftforge.client.model.obj.OBJModel;

public class OBJLoader
implements IModelLoader<OBJModel> {
    public static OBJLoader INSTANCE = new OBJLoader();
    private final Map<OBJModel.ModelSettings, OBJModel> modelCache = Maps.newHashMap();
    private final Map<ResourceLocation, MaterialLibrary> materialCache = Maps.newHashMap();
    private ResourceManager manager = Minecraft.m_91087_().m_91098_();

    public void m_6213_(ResourceManager resourceManager) {
        this.modelCache.clear();
        this.materialCache.clear();
        this.manager = resourceManager;
    }

    @Override
    public OBJModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        if (!modelContents.has("model")) {
            throw new RuntimeException("OBJ Loader requires a 'model' key that points to a valid .OBJ model.");
        }
        String modelLocation = modelContents.get("model").getAsString();
        boolean detectCullableFaces = GsonHelper.m_13855_((JsonObject)modelContents, (String)"detectCullableFaces", (boolean)true);
        boolean diffuseLighting = GsonHelper.m_13855_((JsonObject)modelContents, (String)"diffuseLighting", (boolean)false);
        boolean flipV = GsonHelper.m_13855_((JsonObject)modelContents, (String)"flip-v", (boolean)false);
        boolean ambientToFullbright = GsonHelper.m_13855_((JsonObject)modelContents, (String)"ambientToFullbright", (boolean)true);
        String materialLibraryOverrideLocation = modelContents.has("materialLibraryOverride") ? GsonHelper.m_13906_((JsonObject)modelContents, (String)"materialLibraryOverride") : null;
        return this.loadModel(new OBJModel.ModelSettings(new ResourceLocation(modelLocation), detectCullableFaces, diffuseLighting, flipV, ambientToFullbright, materialLibraryOverrideLocation));
    }

    public OBJModel loadModel(OBJModel.ModelSettings settings) {
        return this.modelCache.computeIfAbsent(settings, data -> {
            try (Resource resource = this.manager.m_142591_(settings.modelLocation());){
                OBJModel oBJModel;
                try (LineReader rdr = new LineReader(resource);){
                    oBJModel = new OBJModel(rdr, settings);
                }
                return oBJModel;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ model", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ model", e);
            }
        });
    }

    public MaterialLibrary loadMaterialLibrary(ResourceLocation materialLocation) {
        return this.materialCache.computeIfAbsent(materialLocation, location -> {
            try (Resource resource = this.manager.m_142591_(location);){
                MaterialLibrary materialLibrary;
                try (LineReader rdr = new LineReader(resource);){
                    materialLibrary = new MaterialLibrary(rdr);
                }
                return materialLibrary;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException("Could not find OBJ material library", e);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not read OBJ material library", e);
            }
        });
    }
}

